<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'login_slug',
        'is_security_question_enabled',
        'security_question',
        'security_answer',
        'homepage_mode',
        'homepage_redirect_url',
        'hard_reset_code',
        'hard_reset_enabled',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'security_answer',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'security_answer' => 'hashed', // Auto hash answer
            'is_security_question_enabled' => 'boolean',
            'hard_reset_enabled' => 'boolean',
        ];
    }

    /**
     * Get the shortlinks for the user.
     */
    public function shortlinks()
    {
        return $this->hasMany(Shortlink::class);
    }
}
