<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DailyTrafficMilestoneNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public $shortlink;
    public $count;

    public function __construct($shortlink, $count)
    {
        $this->shortlink = $shortlink;
        $this->count = $count;
    }

    public function via(object $notifiable): array
    {
        return ['database'];
    }

    public function toArray(object $notifiable): array
    {
        $name = $this->shortlink->title ?: ($this->shortlink->custom_alias ?: $this->shortlink->short_code);
        
        return [
            'title' => 'Trafik Tinggi!',
            'message' => "Link \"{$name}\" sedang ramai! Mencapai {$this->count} kunjungan hari ini.",
            'link_id' => $this->shortlink->id,
            'icon' => 'fa-fire',
            'color' => 'text-orange-500 bg-orange-50',
            'link' => route('shortlinks.index', ['search' => $this->shortlink->short_code])
        ];
    }
}
