<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LinkFirstClickNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public $shortlink;
    public $click;

    public function __construct($shortlink, $click)
    {
        $this->shortlink = $shortlink;
        $this->click = $click;
    }

    public function via(object $notifiable): array
    {
        return ['database'];
    }

    public function toArray(object $notifiable): array
    {
        $name = $this->shortlink->title ?: ($this->shortlink->custom_alias ?: $this->shortlink->short_code);
        $source = $this->click->referer_url 
             ? (parse_url($this->click->referer_url, PHP_URL_HOST) ?: 'External Source') 
             : 'Direct/Unknown';

        return [
            'title' => 'Klik Pertama!',
            'message' => "Link \"{$name}\" berhasil mendapat klik pertama dari {$source}.",
            'link_id' => $this->shortlink->id,
            'icon' => 'fa-bullseye', // Target hit
            'color' => 'text-blue-500 bg-blue-50',
            'link' => route('shortlinks.index', ['search' => $this->shortlink->short_code])
        ];
    }
}
