<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ShortlinkSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = \App\Models\User::first();
        
        if (!$user) {
            $user = \App\Models\User::factory()->create([
                'name' => 'Test User',
                'email' => 'test@example.com',
                'password' => bcrypt('password'),
            ]);
        }

        // Create 10 dummy shortlinks
        for ($i = 0; $i < 10; $i++) {
            \App\Models\Shortlink::create([
                'user_id' => $user->id,
                'original_url' => 'https://example.com/page-' . ($i + 1),
                'short_code' => \Illuminate\Support\Str::random(6),
                'custom_alias' => $i % 3 == 0 ? 'promo-' . ($i + 1) : null, // Every 3rd link gets an alias
                'title' => 'Example Page ' . ($i + 1),
                'description' => 'This is a description for example page ' . ($i + 1),
                'type' => 'url',
                'is_active' => true,
                'total_clicks' => rand(0, 1000),
                'unique_clicks' => rand(0, 500),
                'created_at' => now()->subDays(rand(0, 30)),
            ]);
        }
    }
}
