@extends('layouts.app')

@section('title', 'Hard Reset Password - Selinku')

@push('meta')
<meta name="robots" content="noindex, nofollow">
<meta name="googlebot" content="noindex, nofollow">
@endpush

@section('content')
<style>
    .auth-container {
        min-height: calc(100vh - 200px);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 2rem 1rem;
    }

    .auth-card {
        background: white;
        padding: 2.5rem;
        border-radius: 1rem;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        width: 100%;
        max-width: 450px;
    }

    .auth-header {
        text-align: center;
        margin-bottom: 2rem;
    }

    .form-group {
        margin-bottom: 1.5rem;
    }

    .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 500;
        color: #1e293b;
    }

    .form-control {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 2px solid #e2e8f0;
        border-radius: 0.5rem;
        font-size: 1rem;
        transition: all 0.3s;
    }

    .form-control:focus {
        outline: none;
        border-color: #dc2626;
        box-shadow: 0 0 0 3px rgba(220, 38, 38, 0.1);
    }

    .btn-block {
        width: 100%;
        padding: 0.875rem;
        font-size: 1.125rem;
        border-width: 1px;
        border-radius: 0.5rem;
        cursor: pointer;
        transition: background-color 0.2s;
    }
    
    .btn-block:hover {
        opacity: 0.9;
    }

    @media (max-width: 480px) {
        .auth-card {
            padding: 1.5rem;
        }
    }
</style>

<div class="auth-container">
    <div class="auth-card">
        <div class="auth-header" style="display: flex; flex-direction: column; align-items: center; gap: 0.5rem; margin-bottom: 2rem;">
            <div style="font-size: 2rem; font-weight: bold; color: #dc2626; display: flex; align-items: center; gap: 0.75rem;">
                <i class="fa-solid fa-radiation"></i>
                <span>Hard<span style="color: #1e293b;">Reset</span></span>
            </div>
            <p>Fitur Reset Password Darurat</p>
        </div>

        @if (session('password_reset_success'))
            <div style="color: #059669; background-color: #ecfdf5; border: 1px solid #d1fae5; padding: 1rem; border-radius: 0.5rem; margin-bottom: 2rem; text-align: center;">
                <div style="font-size: 3rem; margin-bottom: 1rem;">
                    <i class="fa-solid fa-circle-check"></i>
                </div>
                <h3 style="font-weight: bold; margin-bottom: 0.5rem;">Berhasil!</h3>
                <p>{{ session('password_reset_success') }}</p>
            </div>
            <!-- Hide forms when success -->
            <style> form { display: none !important; } </style>
        @endif

        @if ($errors->any())
            <div style="color: #dc2626; background-color: #fef2f2; border: 1px solid #fee2e2; padding: 1rem; border-radius: 0.5rem; margin-bottom: 1rem;">
                <ul style="list-style: disc; padding-left: 1.5rem; margin: 0;">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if(empty($email_verified))
            <!-- Step 1: Verify Email -->
            <form action="{{ route('hard-reset.verify', ['code' => $code]) }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="email" class="form-label">Masukkan Email Anda</label>
                    <input type="email" id="email" name="email" class="form-control" required autofocus placeholder="nama@email.com">
                    <p style="font-size: 0.8rem; color: #64748b; margin-top: 0.5rem;">Cocokkan email akun untuk melanjutkan.</p>
                </div>
                <button type="submit" class="btn btn-primary btn-block" style="background-color: #dc2626; border-color: #dc2626; color: white;">
                    Verifikasi
                </button>
            </form>
        @else
            <!-- Step 2: Reset Password -->
            <form action="{{ route('hard-reset.reset', ['code' => $code]) }}" method="POST">
                @csrf
                <input type="hidden" name="email" value="{{ $email }}">
                
                <div class="form-group">
                    <label class="form-label">Email Terverifikasi</label>
                    <input type="email" class="form-control" value="{{ $email }}" disabled style="background-color: #f1f5f9; color: #64748b;">
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">Password Baru</label>
                    <input type="password" id="password" name="password" class="form-control" required autofocus placeholder="Minimal 8 karakter">
                </div>

                <div class="form-group">
                    <label for="password_confirmation" class="form-label">Konfirmasi Password</label>
                    <input type="password" id="password_confirmation" name="password_confirmation" class="form-control" required placeholder="Ulangi password">
                </div>

                <button type="submit" class="btn btn-primary btn-block" style="background-color: #dc2626; border-color: #dc2626; color: white;">
                    Ubah Password
                </button>
            </form>
        @endif
    </div>
</div>
@endsection
