<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ShortlinkController;
use App\Http\Controllers\AnalyticsController;



use App\Http\Controllers\RedirectController;

// Homepage
Route::get('/', [HomeController::class, 'index'])->name('home');

// Authentication Routes
Route::middleware('guest')->group(function () {
    // Custom Login Logic
    // Default 'login' route for middleware redirection (returns 404 for security)
    Route::get('/login', function() { abort(404); })->name('login'); 
    
    // Security Challenge - MUST BE BEFORE login/{slug}
    Route::get('/login/challenge', [LoginController::class, 'showChallengeForm'])->name('login.challenge');
    Route::post('/login/challenge', [LoginController::class, 'verifyChallenge'])->name('login.challenge.post');

    // Actual Login Page with Slug
    Route::get('/login/{slug}', [LoginController::class, 'showLoginForm'])->name('login.custom');
    Route::post('/login', [LoginController::class, 'login'])->name('login.post');
    
    // Register - Disabled
    Route::get('/register', function() { abort(404); })->name('register');
    Route::post('/register', function() { abort(404); })->name('register.post');
});

// Logout
Route::post('/logout', [LoginController::class, 'logout'])->name('logout')->middleware('auth');

// Dashboard (Protected)
Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Shortlink Management
    Route::get('/shortlinks', [ShortlinkController::class, 'index'])->name('shortlinks.index');
    Route::post('/shortlinks', [ShortlinkController::class, 'store'])->name('shortlinks.store');
    Route::patch('/shortlinks/{id}', [ShortlinkController::class, 'update'])->name('shortlinks.update');
    Route::get('/shortlinks/{id}/stats', [ShortlinkController::class, 'stats'])->name('shortlinks.stats'); // Stats API
    Route::post('/shortlinks/fetch-meta', [ShortlinkController::class, 'fetchMeta'])->name('shortlinks.fetch-meta');
    Route::post('/shortlinks/{id}/refresh-meta', [ShortlinkController::class, 'refreshMeta'])->name('shortlinks.refresh-meta');
    Route::delete('/shortlinks/{id}', [ShortlinkController::class, 'destroy'])->name('shortlinks.destroy');

    // Analytics
    Route::get('/analytics', [AnalyticsController::class, 'index'])->name('analytics.index');
    Route::get('/analytics/data', [AnalyticsController::class, 'data'])->name('analytics.data');

    // Notifications
    Route::post('/notifications/read', [App\Http\Controllers\NotificationController::class, 'markAllRead'])->name('notifications.read');
    Route::delete('/notifications/clear', [App\Http\Controllers\NotificationController::class, 'clearAll'])->name('notifications.clear');

    // Profile Settings
    Route::get('/profile', [App\Http\Controllers\ProfileController::class, 'index'])->name('profile.index');
    Route::patch('/profile', [App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
    Route::patch('/profile/homepage', [App\Http\Controllers\ProfileController::class, 'updateHomepage'])->name('profile.homepage');
    
    // Security
    Route::get('/security', [App\Http\Controllers\ProfileController::class, 'security'])->name('security.index');
    Route::patch('/security/slug', [App\Http\Controllers\ProfileController::class, 'updateSlug'])->name('security.slug');
    Route::patch('/security/question', [App\Http\Controllers\ProfileController::class, 'updateSecurityQuestion'])->name('security.question');
    Route::patch('/security/hard-reset', [App\Http\Controllers\ProfileController::class, 'updateHardReset'])->name('security.hard-reset');

    Route::put('/profile/password', [App\Http\Controllers\ProfileController::class, 'updatePassword'])->name('profile.password');

    // Attribution
    Route::view('/attribution', 'dashboard.attribution')->name('attribution');
});

// Hard Reset Password Action Routes
Route::post('/hard-reset/{code}/verify', [App\Http\Controllers\HardResetController::class, 'verifyEmail'])->name('hard-reset.verify');
Route::post('/hard-reset/{code}/reset', [App\Http\Controllers\HardResetController::class, 'resetPassword'])->name('hard-reset.reset');

// Shortlink Redirect (Public - must be last to avoid conflicts)
Route::get('/{code}', [RedirectController::class, 'redirect'])->name('shortlink.redirect');
